
/**********************************************************************************
 Persistence of Vision Ray Tracer Scene Description File
 File name   : Distribution Even_test.pov
 Version     : 3.8
 Description : There are even distributions with a little random noise which work quite well. 

               
 Date        : December 2004
 Author      : Tim Nikias
 E-mail      : 
 
 Copyright (C) 2004-2019. All rights reserved.
**********************************************************************************/

#version 3.8;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
}

//=====================================================================================================================================
// example given by Tim Nikias:
#declare MaxRad = 1;
#declare Counter=0;
#declare TotalAmount=100;

#while (Counter<=TotalAmount)

#declare Pos=vrotate(<MaxRad,0,0>,y*(360/.618*Counter))*sqrt(Counter/TotalAmount);
sphere{Pos,.03 pigment{rgb 0.5}}

#declare Counter=Counter+1;
#end


//=====================================================================================================================================

camera {
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
  angle 50
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

plane {
  y, -1
  pigment { color rgb <0.7,0.5,0.3> }
}

/*
sphere {
  0.0, 1
  texture {
    pigment {
      radial
      frequency 8
      color_map {
        [0.00 color rgb <1.0,0.4,0.2> ]
        [0.33 color rgb <0.2,0.4,1.0> ]
        [0.66 color rgb <0.4,1.0,0.2> ]
        [1.00 color rgb <1.0,0.4,0.2> ]
      }
    }
    finish{
      specular 0.6
    }
  }
}

*/